unit WinForm1;

// Delphi.Net Sample 2oo3 by StJo (stjo@borland.com)

interface

uses
  Borland.Vcl.Classes,
  Borland.Vcl.Sysutils,
  System.Drawing,
  System.Collections,
  System.ComponentModel,
  System.Windows.Forms,
  System.Data;

type
  TMyLabel = class;
  TWinForm1 = class(System.Windows.Forms.Form)
  {$REGION 'Designer Managed Code'}
  strict private
    /// <summary>
    /// Required designer variable.
    /// </summary>
    Components: System.ComponentModel.Container;
    /// <summary>
    /// Required method for Designer support - do not modify
    /// the contents of this method with the code editor.
    /// </summary>
    procedure InitializeComponent;
    procedure TWinForm_Load(sender: System.Object; e: System.EventArgs);
  {$ENDREGION}
  strict protected
    /// <summary>
    /// Clean up any resources being used.
    /// </summary>
    procedure Dispose(Disposing: Boolean); override;
  public
   	size:integer;
		x1,y1:integer;
		mylabels:TList;
    constructor Create;
    procedure Init;
    procedure Melt;
    procedure Verif;
    procedure LabelMouseDown(sender: System.Object; e: System.Windows.Forms.MouseEventArgs);
  end;
	TMyLabel=class(System.Windows.Forms.Label)
	public
  	x,y,okx,oky:integer;
		place:Boolean;
	end;

implementation

{$REGION 'Windows Form Designer generated code'}
/// <summary>
/// Required method for Designer support - do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TWinForm1.InitializeComponent;
begin
  // 
  // TWinForm1
  // 
  Self.AutoScaleBaseSize := System.Drawing.Size.Create(5, 13);
  Self.ClientSize := System.Drawing.Size.Create(232, 222);
  Self.FormBorderStyle := System.Windows.Forms.FormBorderStyle.FixedSingle;
  Self.Name := 'TWinForm1';
  Self.Text := 'Puzzle';
  Include(Self.Load, Self.TWinForm_Load);
end;
{$ENDREGION}

procedure TWinForm1.Dispose(Disposing: Boolean);
begin
  if Disposing then
  begin
    if Components <> nil then
      Components.Dispose();
  end;
  inherited Dispose(Disposing);
end;

constructor TWinForm1.Create;
begin
  inherited Create;
  //
  // Required for Windows Form Designer support
  //
  InitializeComponent;
  //
  // TODO: Add any constructor code after InitializeComponent call
  //
end;

procedure TWinForm1.TWinForm_Load(sender: System.Object; e: System.EventArgs);
begin
  size:=64;
  init();
end;

procedure TWinForm1.Init;
var
  i,x,y:integer;
  mylabel1:TMyLabel;
begin
  mylabels:=TList.Create;
  Self.ClientSize := System.Drawing.Size.Create(4*size,4*size);
	x:=1;
  y:=1;
  for i:=1 to 15 do
  begin
    mylabel1:=TMyLabel.Create;
    mylabel1.BackColor:=System.Drawing.Color.White;
    mylabel1.BorderStyle:=System.Windows.Forms.BorderStyle.Fixed3D;
    mylabel1.Size:=System.Drawing.Size.Create(size,size);
    mylabel1.Font:=System.Drawing.Font.Create('Microsoft Sans Serif', 16, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, (Byte(0)));
    mylabel1.Location:=System.Drawing.Point.Create((x-1)*(size),(y-1)*(size));
    mylabel1.x:=x; mylabel1.okx:=x;
    mylabel1.y:=y; mylabel1.oky:=y;
    mylabel1.TextAlign:=System.Drawing.ContentAlignment.MiddleCenter;
    if (i mod 4=0) then begin x:=1; inc(y); end else begin inc(x); end;
    mylabel1.Text:=IntToStr(i);
    Include(mylabel1.MouseDown, Self.LabelMouseDown);
    Controls.Add(mylabel1);
    mylabels.Add(mylabel1);
  end;
  Melt;
end;

procedure TWinForm1.LabelMouseDown(sender: System.Object; e: System.Windows.Forms.MouseEventArgs);
var
  o:TMyLabel;
begin
  if (sender is TMyLabel) then
  begin
    o:=TMyLabel(sender);
    if (o.x+1=x1) and (o.y=y1) then
    begin
      // right
      o.x:=o.x+1;
      o.Location:=System.Drawing.Point.Create(o.Left+size,o.Top);
      x1:=x1-1;
    end
    else
    begin
      if (o.x-1=x1) and (o.y=y1) then
      begin
        // left
        o.x:=o.x-1;
        o.Location:=System.Drawing.Point.Create(o.Left-size,o.Top);
        x1:=x1+1;
      end
      else
      begin
        if (o.x=x1) and (o.y-1=y1) then
        begin
          // top
          o.y:=o.y-1;
          o.Location:=System.Drawing.Point.Create(o.Left,o.Top-size);
          y1:=y1+1;
        end
        else
        begin
          if (o.x=x1) and (o.y+1=y1) then
          begin
            // bottom
            o.y:=o.y+1;
            o.Location:=System.Drawing.Point.Create(o.Left,o.Top+size);
            y1:=y1-1;
          end;
        end;
      end;
    end;
    verif();
  end;
end;

procedure TWinForm1.Melt;
var
  i,nbplace,x,y:integer;
begin
  //System.Random random=new System.Random();
  nbplace:=0;
  x:=1; y:=1;
  for i:=1 to 15 do
  begin
    TMyLabel(mylabels[i-1]).place:=false;
    TMyLabel(mylabels[i-1]).Visible:=false;
  end;
  while (nbplace<15) do
  begin
    i:=random(15);
    if not(TMyLabel(mylabels[i]).place) then
    begin
      inc(nbplace);
      TMyLabel(mylabels[i]).place:=true;
      TMyLabel(mylabels[i]).Visible:=true;
      TMyLabel(mylabels[i]).x:=x;
      TMyLabel(mylabels[i]).y:=y;
      TMyLabel(mylabels[i]).Location:=System.Drawing.Point.Create((x-1)*(size),(y-1)*(size));
      inc(x);
      if (x mod 4=1) then begin x:=1; inc(y); end;
    end;
  end;
  x1:=4;
  y1:=4;
end;

procedure TWinForm1.Verif;
var
  i,nbok:integer;
  o:TMyLabel;
begin
  nbok:=0;
  for i:=1 to 15 do
  begin
    o:=TMyLabel(mylabels[i-1]);
    if (o.x=o.okx) and (o.y=o.oky) then
    begin
      inc(nbok);
    end;
  end;
  if (nbok=15) then
  begin
    MessageBox.Show('Congralutations'#13#10'You win with Delphi.Net !');
  end;
end;

end.
